package PVE::QemuServer::QMPHelpers;

use warnings;
use strict;

use PVE::QemuServer::Helpers;
use PVE::QemuServer::Monitor qw(mon_cmd);

use base 'Exporter';

our @EXPORT_OK = qw(
qemu_deviceadd
qemu_devicedel
qemu_objectadd
qemu_objectdel
);

sub nbd_stop {
    my ($vmid) = @_;

    mon_cmd($vmid, 'nbd-server-stop', timeout => 25);
}

sub qemu_deviceadd {
    my ($vmid, $devicefull) = @_;

    $devicefull = "driver=".$devicefull;
    my %options =  split(/[=,]/, $devicefull);

    mon_cmd($vmid, "device_add" , %options);
}

sub qemu_devicedel {
    my ($vmid, $deviceid) = @_;

    my $ret = mon_cmd($vmid, "device_del", id => $deviceid);
}

sub qemu_objectadd {
    my ($vmid, $objectid, $qomtype) = @_;

    mon_cmd($vmid, "object-add", id => $objectid, "qom-type" => $qomtype);

    return 1;
}

sub qemu_objectdel {
    my ($vmid, $objectid) = @_;

    mon_cmd($vmid, "object-del", id => $objectid);

    return 1;
}

# dies if a) VM not running or not existing b) Version query failed
# So, any defined return value is valid, any invalid state can be caught by eval
sub runs_at_least_qemu_version {
    my ($vmid, $major, $minor, $extra) = @_;

    my $v = PVE::QemuServer::Monitor::mon_cmd($vmid, 'query-version');
    die "could not query currently running version for VM $vmid\n" if !defined($v);
    $v = $v->{qemu};

    return PVE::QemuServer::Helpers::version_cmp($v->{major}, $major, $v->{minor}, $minor, $v->{micro}, $extra) >= 0;
}

1;
